import type { Component, Editor, Page } from 'grapesjs';
import { AppEditorStore } from '../store/appEditorStore';
import { ProjectDataCustom, StudioPageSettings } from './types';
export interface PageSettingsData extends StudioPageSettings {
    name: string;
}
export declare const incrementDirtyCount: (editor: Editor) => void;
export declare const getComponentIcon: (cmp: Component) => import("react/jsx-runtime").JSX.Element;
export declare const triggerEditorChange: (editor: Editor) => void;
export declare const isHomePage: (page?: Page) => boolean | undefined;
export type ManagedMetaTags = keyof Omit<StudioPageSettings, 'slug' | 'customCodeBody' | 'customCodeHead' | 'fonts'> | 'charset' | 'viewport' | 'robots' | 'generator';
export declare const checkManagedMetaTags: Record<ManagedMetaTags, (props: {
    cmp: Component;
}) => undefined | boolean>;
export declare const getManagedMetaTag: (cmp: Component) => ManagedMetaTags | undefined;
export declare const setPageSettings: (page: Page, value: StudioPageSettings) => Page;
export declare const getPageSettings: (page: Page) => StudioPageSettings;
export declare const setEditorDataCustom: (editor: Editor, value: ProjectDataCustom) => void;
export declare const getEditorDataCustom: (editor: Editor) => ProjectDataCustom;
export declare const getGlobalPageSettings: (appEditorStore?: AppEditorStore) => StudioPageSettings;
export declare const getPageSettingValue: <T extends keyof StudioPageSettings>(props: {
    page?: Page | undefined;
    key: T;
    appEditorStore?: AppEditorStore | undefined;
    def?: StudioPageSettings[T] | undefined;
    defPage?: StudioPageSettings[T] | undefined;
}) => StudioPageSettings[T];
export declare const getPageSettingOrGlobalValue: <T extends keyof StudioPageSettings>(page: Page, key: T) => StudioPageSettings[T];
export declare const getPageData: (page?: Page, appEditorStore?: AppEditorStore) => PageSettingsData;
export declare const getStyleProperty: (editor: Editor, property: string) => import("grapesjs").Property<import("grapesjs").PropertyProps> | undefined;
export declare const getStyleCompositeSubProperty: (editor: Editor, property: string, subProperty: string) => import("grapesjs").Property<import("grapesjs").PropertyProps> | undefined;
