/// <reference types="react" />
import type { Font, InternalFont, ProjectConfigType } from '../types';
export type AnyObject = Record<string, any>;
export type StringObject = Record<string, string>;
export type ValidReactNode = React.ReactNode | (() => React.ReactNode);
export declare enum ProjectType {
    web = "web",
    email = "email",
    document = "document"
}
type PluginOptions = Record<string, any>;
export interface StudioPageSettings {
    slug?: string;
    title?: string;
    favicon?: string;
    description?: string;
    keywords?: string;
    socialTitle?: string;
    socialImage?: string;
    fonts?: Record<string, Font | InternalFont>;
    socialDescription?: string;
    customCodeHead?: string;
    customCodeBody?: string;
}
export type InstallablePlugin = {
    id: string;
    src: string;
    version: string;
    name?: string;
    description?: string;
    options?: PluginOptions;
    projectType: ProjectConfigType[];
};
export type LocalSettingsData = {
    plugins?: InstallablePlugin[];
};
export interface ProjectDataCustom {
    id?: string;
    projectName?: string;
    projectType?: ProjectConfigType;
    plugins?: InstallablePlugin[];
    globalPageSettings?: StudioPageSettings;
}
export interface ProjectData {
    [key: string]: any;
    custom?: ProjectDataCustom;
}
export interface ProjectItem {
    id: string;
    name: string;
    media?: string;
    author?: {
        name: string;
        link?: string;
    };
    isTemplate?: boolean;
    data: ProjectData;
}
export interface BeforeInstallPromptEvent extends Event {
    readonly platforms: string[];
    readonly userChoice: Promise<{
        outcome: 'accepted' | 'dismissed';
        platform: string;
    }>;
    prompt(): Promise<void>;
}
declare global {
    interface WindowEventMap {
        beforeinstallprompt: BeforeInstallPromptEvent;
    }
}
export {};
