<?php
$serverKey   = "43qytQ1W2";
$hardwareKey = "PI3_HTML5_V3";
$endpoint    = "https://xibo.puzaplus.com/xmds.php?v=4";

function soapRequest($method, $paramsXml) {
    global $endpoint;
    $xml = <<<XML
<?xml version="1.0" encoding="UTF-8"?>
<soapenv:Envelope xmlns:soapenv="http://schemas.xmlsoap.org/soap/envelope/" xmlns:xmds="urn:xmds">
  <soapenv:Body>
    <xmds:$method soapenv:encodingStyle="http://schemas.xmlsoap.org/soap/encoding/">
      $paramsXml
    </xmds:$method>
  </soapenv:Body>
</soapenv:Envelope>
XML;

    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $endpoint);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_HTTPHEADER, [
        "Content-Type: text/xml; charset=utf-8",
        "SOAPAction: urn:xmds#$method",
        "Content-Length: " . strlen($xml)
    ]);
    curl_setopt($ch, CURLOPT_POSTFIELDS, $xml);
    $response = curl_exec($ch);
    curl_close($ch);
    return $response;
}

function parseSoapRequiredFiles($soapResponse) {
    if (!preg_match('/<RequiredFilesXml[^>]*>(.*?)<\/RequiredFilesXml>/s', $soapResponse, $match)) {
        die("RequiredFilesXml bulunamadı");
    }
    $xmlStr = html_entity_decode($match[1]);
    $xmlStr = preg_replace('/^\s+/', '', $xmlStr);
    libxml_use_internal_errors(true);
    $xml = simplexml_load_string($xmlStr);
    return $xml ?: null;
}

function downloadFiles($xml, $targetDir) {
    if (!is_dir($targetDir)) mkdir($targetDir, 0777, true);
    foreach ($xml->file as $file) {
        $url = (string)$file['path'];
        $name = (string)$file['saveAs'];
        if (!$url || !$name || file_exists("$targetDir/$name")) continue;
        $content = @file_get_contents($url);
        if ($content !== false) file_put_contents("$targetDir/$name", $content);
    }
}

function renderLayout($layoutPath) {
    if (!file_exists($layoutPath)) die(".xlf layout bulunamadı");

    $layout = simplexml_load_file($layoutPath);
    $w = (int)$layout['width'];
    $h = (int)$layout['height'];
    $bgColor = (string)$layout['bgcolor'] ?: '#000';
    $bgImage = isset($layout['background']) ? "media/" . (string)$layout['background'] : null;

    echo "<div id='layout' style='width:100vw; height:100vh; display:flex; align-items:center; justify-content:center; background-color:$bgColor;'>";
    echo "<div id='layout' style='position:relative; width:{$w}px; height:{$h}px;";
    if ($bgImage) {
        echo "background: url(\"$bgImage\") no-repeat center center; background-size: cover;";
    }
    echo "'>";

    foreach ($layout->region as $region) {
        $l = (int)$region['left'];
        $t = (int)$region['top'];
        $rw = (int)$region['width'];
        $rh = (int)$region['height'];
        $z = (int)$region['zindex'] ?: 1;

        echo "<div style='position:absolute; left:{$l}px; top:{$t}px; width:{$rw}px; height:{$rh}px; z-index:$z; overflow:hidden;'>";

        foreach ($region->media as $media) {
            $type = (string)$media['type'];

            if ($type === 'image') {
                $src = (string)$media->options->uri;
                echo "<img src='media/$src' style='width:100%; height:100%; object-fit:contain;'>";
            }

            elseif ($type === 'video') {
                $src = (string)$media->options->uri;
                $muted = ((string)$media->options->mute === '1') ? 'muted' : '';
                echo "<video src='media/$src' autoplay loop $muted style='width:100%; height:100%; object-fit:cover;'></video>";
            }

            elseif ($type === 'clock-digital') {
                echo "<div style='color:white; font-size:24px;'>" . date('H:i:s') . "</div>";
            }

            elseif ($type === 'global') {
                echo "<div style='width:100%; height:100%; background: rgba(255,255,255,0.05); color:#ccc;'>[GLOBAL CONTENT]</div>";
            }

            elseif ($type === 'html') {
                echo (string)$media->raw;
            }

            else {
                echo "<div style='color:red;'>[$type desteği yok]</div>";
            }
        }

        echo "</div>"; // region
    }

    echo "</div></div>"; // layout + container
}


$responseXml = soapRequest("RegisterDisplay", "
    <serverKey>$serverKey</serverKey>
    <hardwareKey>$hardwareKey</hardwareKey>
    <displayName>PlayerV3</displayName>
    <clientType>Linux</clientType>
    <clientVersion>3.0.0</clientVersion>
    <clientCode>303</clientCode>
    <operatingSystem>Linux</operatingSystem>
    <macAddress>AA:BB:CC:DD:EE:FF</macAddress>
");

if (!(str_contains($responseXml, 'status="0"') && str_contains($responseXml, 'code="READY"'))) {
    die("Ekran yetkili değil veya kayıt reddedildi.");
}

$requiredXml = soapRequest("RequiredFiles", "
    <serverKey>$serverKey</serverKey>
    <hardwareKey>$hardwareKey</hardwareKey>
");

$xml = parseSoapRequiredFiles($requiredXml);
$layoutFile = null;
if ($xml) {
    downloadFiles($xml, 'media');
    foreach ($xml->file as $file) {
        if ((string)$file['type'] === 'layout') {
            $layoutFile = "media/" . (string)$file['saveAs'];
            break;
        }
    }
}

$cssIncludes = $jsIncludes = $fontFaceCss = '';
foreach (glob("media/*.css") as $css) {
    $cssIncludes .= "<link rel='stylesheet' href='$css'>\n";
}
foreach (glob("media/*.js") as $js) {
    $jsIncludes .= "<script src='$js'></script>\n";
}
$fontTypes = ['otf' => 'opentype', 'ttf' => 'truetype'];
foreach (glob("media/*.{otf,ttf}", GLOB_BRACE) as $fontFile) {
    $fontName = pathinfo($fontFile, PATHINFO_FILENAME);
    $ext = pathinfo($fontFile, PATHINFO_EXTENSION);
    $format = $fontTypes[$ext] ?? 'truetype';
    $fontFaceCss .= "@font-face { font-family: '$fontName'; src: url('$fontFile') format('$format'); }\n";
}

?><!DOCTYPE html>
<html lang="tr">
<head>
<meta charset="UTF-8">
<title>Xibo HTML5 Player</title>
<meta name="viewport" content="width=device-width, initial-scale=1">
<?= $cssIncludes ?>
<style>
html, body { margin: 0; padding: 0; background: #000; overflow: hidden; }
#layout { transform-origin: top left; position: relative; transform: scale(1); }
<?= $fontFaceCss ?>
</style>
</head>
<body>
<?= $layoutFile ? renderLayout($layoutFile) : "<p>Layout bulunamadı.</p>" ?>
<?= $jsIncludes ?>
</body>
</html>
