<?php
$serverKey   = "43qytQ1W";
$hardwareKey = "PI3_HTML5_001";
$endpoint    = "https://xibo.puzaplus.com/xmds.php?v=4";

function soapRequest($method, $paramsXml) {
    global $endpoint;
    $xml = <<<XML
<?xml version="1.0" encoding="UTF-8"?>
<soapenv:Envelope xmlns:soapenv="http://schemas.xmlsoap.org/soap/envelope/" xmlns:xmds="urn:xmds">
  <soapenv:Body>
    <xmds:$method soapenv:encodingStyle="http://schemas.xmlsoap.org/soap/encoding/">
      $paramsXml
    </xmds:$method>
  </soapenv:Body>
</soapenv:Envelope>
XML;

    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $endpoint);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_HTTPHEADER, [
        "Content-Type: text/xml; charset=utf-8",
        "SOAPAction: urn:xmds#$method",
        "Content-Length: " . strlen($xml)
    ]);
    curl_setopt($ch, CURLOPT_POSTFIELDS, $xml);
    $response = curl_exec($ch);
    curl_close($ch);
    return $response;
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $data = json_decode(file_get_contents("php://input"), true);
    $mediaId = $data['mediaId'];
    $duration = $data['duration'];
    $layoutId = $data['layoutId'];

    $startTime = date("Y-m-d H:i:s");
    $endTime = date("Y-m-d H:i:s", time() + $duration);

    $statXml = <<<XML
<stats>
  <stat>
    <type>media</type>
    <fromdt>$startTime</fromdt>
    <todt>$endTime</todt>
    <mediaid>$mediaId</mediaid>
    <layoutid>$layoutId</layoutid>
    <eventType>play</eventType>
  </stat>
</stats>
XML;

    $response = soapRequest("SubmitStats", "
        <serverKey>$serverKey</serverKey>
        <hardwareKey>$hardwareKey</hardwareKey>
        <statXml><![CDATA[$statXml]]></statXml>
    ");

    echo json_encode(["status" => "sent", "cms_response" => $response]);
}
?>
