@php
    $builderContent = $getState();
@endphp

<textarea id="builder-editor" name="{{ $getStatePath() }}">{{ $builderContent }}</textarea>

<script src="https://cdn.tiny.cloud/1/no-api-key/tinymce/6/tinymce.min.js" referrerpolicy="origin"></script>

<script>
    document.addEventListener('livewire:load', function () {
        if (tinymce.get('builder-editor')) {
            tinymce.get('builder-editor').remove();
        }

        tinymce.init({
            selector: '#builder-editor',
            height: 500,
            menubar: true,
            plugins: 'code lists link image table',
            toolbar: 'undo redo | formatselect | bold italic underline | alignleft aligncenter alignright alignjustify | bullist numlist | code | link image table',
            setup: function (editor) {
                editor.on('change', function () {
                    editor.save(); // textarea ile senkronize eder
                });
            }
        });
    });

    // Livewire güncellenince TinyMCE senkronizasyonu bozulmasın diye hook
    Livewire.hook('message.sent', () => {
        const editor = tinymce.get('builder-editor');
        if (editor) {
            editor.save();
        }
    });
</script>
