@php
    $data = $getRecord()->form_data ?? [];
@endphp

<table class="table w-full text-sm">
    <thead>
        <tr class="bg-gray-100">
            <th class="px-4 py-2 text-left">Alan</th>
            <th class="px-4 py-2 text-left">Değer</th>
        </tr>
    </thead>
    <tbody>
        @foreach ($data as $key => $value)
            <tr class="border-t">
                <td class="px-4 py-2 font-medium">{{ $key }}</td>
                <td class="px-4 py-2 break-words">
                    @if (Str::startsWith($value, 'applications/'))
                        <a href="{{ asset('storage/' . $value) }}" target="_blank" class="text-blue-600 underline">Dosyayı Görüntüle</a>
                    @else
                        {{ $value }}
                    @endif
                </td>
            </tr>
        @endforeach
    </tbody>
</table>
