@php
    $fields = collect($project->form_config)->pluck('label')->toArray();
@endphp

<table class="table w-full text-sm border">
    <thead>
        <tr class="bg-gray-100">
            <th class="px-2 py-1 text-left">#</th> {{-- Numaratör sütunu --}}
            @foreach($fields as $field)
                <th class="px-2 py-1 text-left">{{ $field }}</th>
            @endforeach
            <th class="px-2 py-1 text-left">Tarih</th>
        </tr>
    </thead>
    <tbody>
        @forelse($applications as $index => $app)
            <tr class="border-t">
                <td class="px-2 py-1">{{ $index + 1 }}</td> {{-- Numaratör değeri --}}
                @foreach($fields as $field)
                    <td class="px-2 py-1">
                        @php $val = $app->form_data[$field] ?? ''; @endphp
                        @if(Str::startsWith($val, 'applications/'))
                            <a href="{{ asset('storage/' . $val) }}" class="text-blue-600 underline" target="_blank">Dosya</a>
                        @else
                            {{ $val }}
                        @endif
                    </td>
                @endforeach
                <td class="px-2 py-1">{{ $app->created_at->format('d.m.Y H:i') }}</td>
            </tr>
        @empty
            <tr>
                <td colspan="{{ count($fields) + 2 }}" class="text-center text-gray-500 py-3">Başvuru bulunamadı.</td>
            </tr>
        @endforelse
    </tbody>
</table>
