@php
    $hasChildren = $menu->children->count() > 0;
    $isActive = request()->is(ltrim($menu->url, '/')) ? 'active' : '';
    $hasChildrenClass = $hasChildren ? 'menu-item-has-children' : '';
    $imageUrl = $menu->images ? asset('storage/' . $menu->images) : null;
@endphp

<li class="scroll {{ $hasChildrenClass }} {{ $isActive }}">
    <a href="{{ url($menu->url ?? ($menu->page ? url($menu->page->slug) : '#')) }}">
        @if($imageUrl)
            <img src="{{ $imageUrl }}" alt="{{ $menu->label }}" style="max-height: 70px;">
        @else
            {{ $menu->label }}
        @endif
    </a>

    @if($hasChildren)
        <ul class="sub-menu">
            @foreach($menu->children as $child)
                @include('lyt.partials.menu-item', ['menu' => $child])
            @endforeach
        </ul>
    @endif
</li>
