@extends('lyt.app')


@section('title', $news->title)





@section('meta')
<meta name="description" content="{{ Str::limit(strip_tags($news->content), 160) }}">
<link rel="canonical" href="{{ route('news.detail', $news->slug) }}" />

{{-- Open Graph (Facebook, LinkedIn, WhatsApp) --}}
<meta property="og:type" content="article" />
<meta property="og:title" content="{{ $news->title }}" />
<meta property="og:description" content="{{ Str::limit(strip_tags($news->content), 160) }}" />
<meta property="og:url" content="{{ route('news.detail', $news->slug) }}" />
<meta property="og:image" content="{{ asset('storage/' . $news->image) }}" />
<meta property="og:site_name" content="{{ config('app.name') }}" />

{{-- Twitter Card --}}
<meta name="twitter:card" content="summary_large_image" />
<meta name="twitter:title" content="{{ $news->title }}" />
<meta name="twitter:description" content="{{ Str::limit(strip_tags($news->content), 160) }}" />
<meta name="twitter:image" content="{{ asset('storage/' . $news->image) }}" />
<meta name="twitter:site" content="@TABIDresmi" /> {{-- varsa Twitter kullanıcı adı --}}

{{-- Google için schema.org --}}
<meta itemprop="name" content="{{ $news->title }}">
<meta itemprop="description" content="{{ Str::limit(strip_tags($news->content), 160) }}">
<meta itemprop="image" content="{{ asset('storage/' . $news->image) }}">
@endsection

@push('styles')
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/@fancyapps/ui/dist/fancybox.css" />
@endpush

@push('scripts')
<script src="https://cdn.jsdelivr.net/npm/@fancyapps/ui/dist/fancybox.umd.js"></script>
@endpush



@section('content')

<section class="pageBanner">
    <div class="container">
        <div class="row">
            <div class="col-lg-12">
                <div class="banner_content text-center">
                    <h2>{{ $news->title }}</h2>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Blog Detail Section -->
<section class="commonSection blogDetails">
    <div class="container">
        <div class="row">
            <div class="col-lg-8 col-sm-8">
                <div class="single_blog">
                    <div class="blog_thumb">
                        <img src="{{ asset('storage/' . $news->image) }}" alt=""/>
                    </div>
                    <div class="blog_headings">
                        <span class="blog_date">{{ $news->created_at->format('d F, Y') }}</span>
                        <h2>{{ $news->title }}</h2>
                        <p class="blog_metas">
                            <a href="#">By Admin</a> - <a href="#">0 Likes</a> - <a href="#">0 Comments</a>
                        </p>
                    </div>
                    <div class="blog_details">
                            {!! $news->content !!}
                    </div>
                    <!-- İsteğe bağlı: Yazar, Yorumlar, Yorum Formu -->
                </div>
            </div>

            <div class="col-lg-4 col-sm-4 sidebar">
                <aside class="widget search-widget">
                    <form method="post" action="#" class="searchform">
                        <input type="search" placeholder="İçerik Arama..." name="s" id="s">
                    </form>
                </aside>

                <aside class="widget recent_posts">
                    <h3 class="widget_title">Son Paylaşımlar</h3>
                    <div class="meipaly_post_widget">

                        @foreach($newsd->take(5) as $recent)


                            <div class="mpw_item">
                                <img src="{{ asset('storage/' . $recent->image) }}" alt="">
                                <a href="{{ route('news.detail', $recent->slug) }}">{{ \Str::limit($recent->title, 40) }}</a>
                            </div>
                        @endforeach
                    </div>
                </aside>


            </div>
        </div>
    </div>
</section>


@endsection
