@extends('lyt.app')

@section('title', $menu->label)

@section('content')


<div class="breadcumb-wrapper" data-bg-src="">
    <div class="container">
        <div class="breadcumb-content">
            <h1 class="breadcumb-title">{{ $menu->label}}</h1>
            <ul class="breadcumb-menu">
          <li><a href="{{ url('/') }}">Anasayfa</a></li>
          @foreach($breadcrumb as $item)
              @php
                  $itemUrl = is_string($item['url']) ? url($item['url']) : $item['url'];
              @endphp
              <li><a href="{{ $itemUrl }}">{{ $item['label'] }}</a></li>
          @endforeach
      </ul>

        </div>
    </div>
</div>
<section class="th-blog-wrapper space-top space-extra-bottom">
    <div class="container">
        <div class="row">
            <div class="col-xxl-8 col-lg-7">
                @foreach($news as $item)
                    <div class="th-blog blog-single has-post-thumbnail">
                        <div class="blog-img">
                            <a href="{{ route('news.detail', $item->slug) }}">
                                <img src="{{ asset('storage/' . $item->image) }}" alt="{{ $item->title }}">
                            </a>
                        </div>
                        <div class="blog-content">
                            <div class="blog-meta">
                                <a class="author" href="#"><img src="https://tabid.org.tr/wp-content/uploads/2022/08/tabidnewlogoxsiyah-100x100.png" alt="avater"> By {{ config('app.name') }}</a>
                                <a href="#"><i class="fa-light fa-calendar-days"></i> {{ $item->created_at->format('d M, Y') }}</a>
                                {{-- Yorum sayısı varsa buraya eklenebilir --}}
                            </div>
                            <h2 class="blog-title">
                                <a href="{{ route('news.detail', $item->slug) }}">{{ $item->title }}</a>
                            </h2>
                            <p class="blog-text">{!! Str::limit(strip_tags($item->content), 250) !!}</p>
                            <a href="{{ route('news.detail', $item->slug) }}" class="line-btn">Devamını Oku</a>
                        </div>
                    </div>
                @endforeach

                <div class="th-pagination text-center">
                    {{ $news->links() }}
                </div>
            </div>

            <div class="col-xxl-4 col-lg-5">
                <aside class="sidebar-area">
                    {{-- Buraya isteğe bağlı widget'lar eklenebilir --}}
                    <div class="widget widget_search">
                        <form class="search-form">
                            <input type="text" placeholder="Anahtar Kelime Girin">
                            <button type="submit"><i class="far fa-search"></i></button>
                        </form>
                    </div>

                    <div class="widget">
                        <h3 class="widget_title">Son Haberler</h3>
                        <div class="recent-post-wrap">
                            @foreach($news->take(3) as $recent)
                                <div class="recent-post">
                                    <div class="media-img">
                                        <a href="{{ route('news.detail', $recent->slug) }}">
                                            <img src="{{ asset('storage/' . $recent->image) }}" alt="{{ $recent->title }}">
                                        </a>
                                    </div>
                                    <div class="media-body">
                                        <h4 class="post-title"><a class="text-inherit" href="{{ route('news.detail', $recent->slug) }}">{{ $recent->title }}</a></h4>
                                        <div class="recent-post-meta">
                                            <a href="#"><i class="fal fa-calendar-days"></i> {{ $recent->created_at->format('d M, Y') }}</a>
                                        </div>
                                    </div>
                                </div>
                            @endforeach
                        </div>
                    </div>
                </aside>
            </div>
        </div>
    </div>
</section>


@endsection
