@extends('lyt.app')

@section('title', $project->title)

@section('content')
<section class="space-top space-extra-bottom">
    <div class="container">
        <div class="row">
            <!-- Sol içerik alanı -->
            <div class="col-xxl-8 col-lg-8 order-2">
                <div class="page-single">
                    <div class="page-content">
                        <h2 class="h3 page-title">{{ $project->title }}</h2>
                        <div class="mb-4">
                            {!! $project->content !!}
                        </div>

                        {{-- Eğer bir haberle ilişkilendirilmişse haberi göster --}}
                        @if ($project->related_news_id && $relatedNews = \App\Models\News::find($project->related_news_id))
                            <div class="mt-5">
                                <h3 class="box-title">{{ $relatedNews->title }}</h3>
                                <div class="mb-3">
                                    {!! $relatedNews->content !!}
                                </div>
                            </div>

                            @if (is_array(json_decode($relatedNews->gallery, true)))
    <div class="row mt-4">
        @foreach (json_decode($relatedNews->gallery, true) as $img)
            <div class="col-md-3 mb-4">
                <a href="{{ asset('storage/' . $img) }}" class="popup-image d-block rounded-3 overflow-hidden">
                    <img class="w-100" src="{{ asset('storage/' . $img) }}" loading="lazy" alt="{{ $relatedNews->title }}">
                </a>
            </div>
        @endforeach
    </div>
@endif

                        @elseif ($project->form_config)
                            {{-- Aksi halde başvuru formunu göster --}}
                            <div class="mt-5">
                                <h3 class="box-title">Başvuru Formu</h3>
                                @include('projects.form', ['project' => $project])
                            </div>
                        @endif
                    </div>
                </div>
            </div>


            <!-- Sağ bilgi alanı -->
            <div class="col-xxl-4 col-lg-4 order-1">
                <aside class="sidebar-area">

                    @if ($project->image)
                        <div class="widget mb-4">
                            <img src="{{ asset('storage/' . $project->image) }}" alt="{{ $project->title }}" class="w-100 rounded-3" style="object-fit: cover;">
                        </div>
                    @endif

                    <div class="widget widget_info">
                        <h3 class="widget_title">Program Hakkında</h3>
                        <div class="project-info-list">
                            <div class="contact-feature">
                                <div class="icon-btn"><i class="fa-solid fa-calendar-days"></i></div>
                                <div class="media-body">
                                    <p class="contact-feature_label">Program Tarihi:</p>
                                    <span class="contact-feature_link">{{ $project->etkinliktarih }}</span>
                                </div>
                            </div>
                            <div class="contact-feature">
                                <div class="icon-btn"><i class="fa-solid fa-map"></i></div>
                                <div class="media-body">
                                    <p class="contact-feature_label">Konum:</p>
                                    <span class="contact-feature_link">{{ $project->etkinlikkonum }}</span>
                                </div>
                            </div>

                            @if ($project->related_news_id && $relatedNews = \App\Models\News::find($project->related_news_id))
    <div class="contact-feature">
        <div class="icon-btn"><i class="fa-solid fa-circle-check"></i></div>
        <div class="media-body">
            <p class="contact-feature_label">Etkinlik Durumu:</p>
            <span class="contact-feature_link text-success">Etkinlik tamamlandı</span>
        </div>
    </div>
@else
    <div class="contact-feature">
        <div class="icon-btn"><i class="fa-solid fa-circle-play"></i></div>
        <div class="media-body">
            <p class="contact-feature_label">Etkinlik Durumu:</p>
            @if ($project->external_url)
                <a href="{{ $project->external_url }}" target="_blank" class="contact-feature_link text-primary">Dış Link</a>
            @else
                <span class="contact-feature_link">Bu sayfa üzerinden başvuru yapılabilir</span>
            @endif
        </div>
    </div>
@endif
                        </div>
                    </div>

                </aside>
            </div>
        </div>
    </div>
</section>
@endsection
