<form action="{{ route('project.apply', $project->slug) }}" id="projectForm" method="POST" enctype="multipart/form-data" class="row g-3">
    @csrf

    @foreach ($project->form_config ?? [] as $field)
        <div class="col-md-6">
            <label class="form-label">{{ $field['label'] }} @if($field['required']) * @endif</label>

            @if($field['type'] === 'text')
                <input type="text" name="form[{{ $field['label'] }}]" class="form-control" @if($field['required']) required @endif>
            @elseif($field['type'] === 'email')
                <input type="email" name="form[{{ $field['label'] }}]" class="form-control" @if($field['required']) required @endif>
            @elseif($field['type'] === 'textarea')
                <textarea name="form[{{ $field['label'] }}]" class="form-control" rows="4" @if($field['required']) required @endif></textarea>
            @elseif($field['type'] === 'file')
                <input type="file" name="form[{{ $field['label'] }}]" class="form-control" @if($field['required']) required @endif>
            @endif
        </div>
    @endforeach

    <div class="col-12">
        <button type="submit" class="btn btn-primary">Başvuruyu Gönder</button>
    </div>
</form>

@push('scripts')
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<script>
    document.addEventListener('DOMContentLoaded', function () {
        const form = document.getElementById('projectForm');

        form.addEventListener('submit', function (e) {
            e.preventDefault();

            Swal.fire({
                title: 'Başvuruyu Göndermek İstiyor musunuz?',
                icon: 'question',
                showCancelButton: true,
                confirmButtonText: 'Evet, Gönder',
                cancelButtonText: 'Vazgeç',
            }).then((result) => {
                if (!result.isConfirmed) return;

                const formData = new FormData(form);

                fetch(form.action, {
                    method: 'POST',
                    headers: {
                        'X-CSRF-TOKEN': document.querySelector('input[name="_token"]').value
                    },
                    body: formData
                })
                .then(res => res.json())
                .then(data => {
                    if (data.success) {
                        Swal.fire({
                            icon: 'success',
                            title: 'Başvurunuz alındı!',
                            text: data.message,
                            confirmButtonText: 'Tamam'
                        });
                        form.reset();
                    } else {
                        Swal.fire({
                            icon: 'error',
                            title: 'Hata!',
                            text: data.message || 'Form gönderilirken hata oluştu.',
                        });
                    }
                })
                .catch(error => {
                    Swal.fire({
                        icon: 'error',
                        title: 'Sunucu Hatası!',
                        text: 'Lütfen daha sonra tekrar deneyin.',
                    });
                    console.error(error);
                });
            });
        });
    });
</script>

@endpush
