<?php

use Illuminate\Support\Facades\Route;
use Spatie\Sitemap\Sitemap;
use Spatie\Sitemap\Tags\Url;
use Illuminate\Support\Carbon;
use App\Models\Page;
use App\Models\News;
use App\Models\Project;
/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "web" middleware group. Make something great!
|
*/

Route::get('/', [App\Http\Controllers\PageController::class, 'home'])->name('homepage');


Route::get('/sitemap.xml', function () {
    $sitemap = Sitemap::create()
        ->add(Url::create('/'))
        ->add(Url::create('/hakkimizda'))
        ->add(Url::create('/iletisim'));


        // Sayfalar (type: page olanlar)
        Page::all()->each(function ($page) use ($sitemap) {
            $sitemap->add(
                Url::create(url($page->slug))
                    ->setLastModificationDate($page->updated_at ?? Carbon::now())
            );
        });

        // Haberler
        News::where('status', true)->get()->each(function ($news) use ($sitemap) {
            $sitemap->add(
                Url::create(route('news.detail', $news->slug))
                    ->setLastModificationDate($news->updated_at ?? Carbon::now())
            );
        });

        // Projeler (status kontrolsüz)
        Project::all()->each(function ($project) use ($sitemap) {
            if ($project->external_url) {
                // Dış linkli olanlar sitemap'e eklenmiyor
                return;
            }

            $sitemap->add(
                Url::create(route('project.detail', $project->slug))
                    ->setLastModificationDate($project->updated_at ?? Carbon::now())
            );
        });
    return $sitemap->toResponse(request());
});

Route::get('/haber/{slug?}', [App\Http\Controllers\PageController::class, 'detail'])->name('news.detail');
Route::get('/projeler/{slug}', [App\Http\Controllers\PageController::class, 'project'])->name('project.detail');



Route::get('/{slug?}', [App\Http\Controllers\PageController::class, 'show'])
    ->where('slug', '.*')
    ->name('page.show');


Route::post('/project/{slug}/apply', [App\Http\Controllers\PageController::class, 'apply'])->name('project.apply');
