<form action="<?php echo e(route('project.apply', $project->slug)); ?>" id="projectForm" method="POST" enctype="multipart/form-data" class="row g-3">
    <?php echo csrf_field(); ?>

    <?php $__currentLoopData = $project->form_config ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $field): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <div class="col-md-6">
            <label class="form-label"><?php echo e($field['label']); ?> <?php if($field['required']): ?> * <?php endif; ?></label>

            <?php if($field['type'] === 'text'): ?>
                <input type="text" name="form[<?php echo e($field['label']); ?>]" class="form-control" <?php if($field['required']): ?> required <?php endif; ?>>
            <?php elseif($field['type'] === 'email'): ?>
                <input type="email" name="form[<?php echo e($field['label']); ?>]" class="form-control" <?php if($field['required']): ?> required <?php endif; ?>>
            <?php elseif($field['type'] === 'textarea'): ?>
                <textarea name="form[<?php echo e($field['label']); ?>]" class="form-control" rows="4" <?php if($field['required']): ?> required <?php endif; ?>></textarea>
            <?php elseif($field['type'] === 'file'): ?>
                <input type="file" name="form[<?php echo e($field['label']); ?>]" class="form-control" <?php if($field['required']): ?> required <?php endif; ?>>
            <?php endif; ?>
        </div>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

    <div class="col-12">
        <button type="submit" class="btn btn-primary">Başvuruyu Gönder</button>
    </div>
</form>

<?php $__env->startPush('scripts'); ?>
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<script>
    document.addEventListener('DOMContentLoaded', function () {
        const form = document.getElementById('projectForm');

        form.addEventListener('submit', function (e) {
            e.preventDefault();

            Swal.fire({
                title: 'Başvuruyu Göndermek İstiyor musunuz?',
                icon: 'question',
                showCancelButton: true,
                confirmButtonText: 'Evet, Gönder',
                cancelButtonText: 'Vazgeç',
            }).then((result) => {
                if (!result.isConfirmed) return;

                const formData = new FormData(form);

                fetch(form.action, {
                    method: 'POST',
                    headers: {
                        'X-CSRF-TOKEN': document.querySelector('input[name="_token"]').value
                    },
                    body: formData
                })
                .then(res => res.json())
                .then(data => {
                    if (data.success) {
                        Swal.fire({
                            icon: 'success',
                            title: 'Başvurunuz alındı!',
                            text: data.message,
                            confirmButtonText: 'Tamam'
                        });
                        form.reset();
                    } else {
                        Swal.fire({
                            icon: 'error',
                            title: 'Hata!',
                            text: data.message || 'Form gönderilirken hata oluştu.',
                        });
                    }
                })
                .catch(error => {
                    Swal.fire({
                        icon: 'error',
                        title: 'Sunucu Hatası!',
                        text: 'Lütfen daha sonra tekrar deneyin.',
                    });
                    console.error(error);
                });
            });
        });
    });
</script>

<?php $__env->stopPush(); ?>
<?php /**PATH /home/tabidor/tabid/resources/views/projects/form.blade.php ENDPATH**/ ?>