


<?php $__env->startSection('title', $news->title); ?>





<?php $__env->startSection('meta'); ?>
<meta name="description" content="<?php echo e(Str::limit(strip_tags($news->content), 160)); ?>">
<link rel="canonical" href="<?php echo e(route('news.detail', $news->slug)); ?>" />


<meta property="og:type" content="article" />
<meta property="og:title" content="<?php echo e($news->title); ?>" />
<meta property="og:description" content="<?php echo e(Str::limit(strip_tags($news->content), 160)); ?>" />
<meta property="og:url" content="<?php echo e(route('news.detail', $news->slug)); ?>" />
<meta property="og:image" content="<?php echo e(asset('storage/' . $news->image)); ?>" />
<meta property="og:site_name" content="<?php echo e(config('app.name')); ?>" />


<meta name="twitter:card" content="summary_large_image" />
<meta name="twitter:title" content="<?php echo e($news->title); ?>" />
<meta name="twitter:description" content="<?php echo e(Str::limit(strip_tags($news->content), 160)); ?>" />
<meta name="twitter:image" content="<?php echo e(asset('storage/' . $news->image)); ?>" />
<meta name="twitter:site" content="@TABIDresmi" /> 


<meta itemprop="name" content="<?php echo e($news->title); ?>">
<meta itemprop="description" content="<?php echo e(Str::limit(strip_tags($news->content), 160)); ?>">
<meta itemprop="image" content="<?php echo e(asset('storage/' . $news->image)); ?>">
<?php $__env->stopSection(); ?>

<?php $__env->startPush('styles'); ?>
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/@fancyapps/ui/dist/fancybox.css" />
<?php $__env->stopPush(); ?>

<?php $__env->startPush('scripts'); ?>
<script src="https://cdn.jsdelivr.net/npm/@fancyapps/ui/dist/fancybox.umd.js"></script>
<?php $__env->stopPush(); ?>



<?php $__env->startSection('content'); ?>

<section class="pageBanner">
    <div class="container">
        <div class="row">
            <div class="col-lg-12">
                <div class="banner_content text-center">
                    <h2><?php echo e($news->title); ?></h2>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Blog Detail Section -->
<section class="commonSection blogDetails">
    <div class="container">
        <div class="row">
            <div class="col-lg-8 col-sm-8">
                <div class="single_blog">
                    <div class="blog_thumb">
                        <img src="<?php echo e(asset('storage/' . $news->image)); ?>" alt=""/>
                    </div>
                    <div class="blog_headings">
                        <span class="blog_date"><?php echo e($news->created_at->format('d F, Y')); ?></span>
                        <h2><?php echo e($news->title); ?></h2>
                        <p class="blog_metas">
                            <a href="#">By Admin</a> - <a href="#">0 Likes</a> - <a href="#">0 Comments</a>
                        </p>
                    </div>
                    <div class="blog_details">
                            <?php echo $news->content; ?>

                    </div>
                    <!-- İsteğe bağlı: Yazar, Yorumlar, Yorum Formu -->
                </div>
            </div>

            <div class="col-lg-4 col-sm-4 sidebar">
                <aside class="widget search-widget">
                    <form method="post" action="#" class="searchform">
                        <input type="search" placeholder="İçerik Arama..." name="s" id="s">
                    </form>
                </aside>

                <aside class="widget recent_posts">
                    <h3 class="widget_title">Son Paylaşımlar</h3>
                    <div class="meipaly_post_widget">

                        <?php $__currentLoopData = $newsd->take(5); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $recent): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>


                            <div class="mpw_item">
                                <img src="<?php echo e(asset('storage/' . $recent->image)); ?>" alt="">
                                <a href="<?php echo e(route('news.detail', $recent->slug)); ?>"><?php echo e(\Str::limit($recent->title, 40)); ?></a>
                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                </aside>


            </div>
        </div>
    </div>
</section>


<?php $__env->stopSection(); ?>

<?php echo $__env->make('lyt.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/kubeycr/figenkonak/resources/views/pages/news-detail.blade.php ENDPATH**/ ?>