


<?php $__env->startSection('title', $news->title); ?>





<?php $__env->startSection('meta'); ?>
<meta name="description" content="<?php echo e(Str::limit(strip_tags($news->content), 160)); ?>">
<link rel="canonical" href="<?php echo e(route('news.detail', $news->slug)); ?>" />


<meta property="og:type" content="article" />
<meta property="og:title" content="<?php echo e($news->title); ?>" />
<meta property="og:description" content="<?php echo e(Str::limit(strip_tags($news->content), 160)); ?>" />
<meta property="og:url" content="<?php echo e(route('news.detail', $news->slug)); ?>" />
<meta property="og:image" content="<?php echo e(asset('storage/' . $news->image)); ?>" />
<meta property="og:site_name" content="<?php echo e(config('app.name')); ?>" />


<meta name="twitter:card" content="summary_large_image" />
<meta name="twitter:title" content="<?php echo e($news->title); ?>" />
<meta name="twitter:description" content="<?php echo e(Str::limit(strip_tags($news->content), 160)); ?>" />
<meta name="twitter:image" content="<?php echo e(asset('storage/' . $news->image)); ?>" />
<meta name="twitter:site" content="@TABIDresmi" /> 


<meta itemprop="name" content="<?php echo e($news->title); ?>">
<meta itemprop="description" content="<?php echo e(Str::limit(strip_tags($news->content), 160)); ?>">
<meta itemprop="image" content="<?php echo e(asset('storage/' . $news->image)); ?>">
<?php $__env->stopSection(); ?>

<?php $__env->startPush('styles'); ?>
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/@fancyapps/ui/dist/fancybox.css" />
<?php $__env->stopPush(); ?>

<?php $__env->startPush('scripts'); ?>
<script src="https://cdn.jsdelivr.net/npm/@fancyapps/ui/dist/fancybox.umd.js"></script>
<?php $__env->stopPush(); ?>



<?php $__env->startSection('content'); ?>
<div class="breadcumb-wrapper" >
    <div class="container">
        <div class="breadcumb-content">
            <h1 class="breadcumb-title"><?php echo e($news->title); ?></h1>
            <ul class="breadcumb-menu">
                <li><a href="/">Anasayfa</a></li>
                <li><?php echo e($news->title); ?></li>
            </ul>
        </div>
    </div>
</div>

<section class="th-blog-wrapper blog-details space-top space-extra-bottom">
    <div class="container">
        <div class="row">
            <div class="col-xxl-8 col-lg-7">
                <div class="th-blog blog-single">
                    <?php if($news->image): ?>
                    <div class="blog-img">
                        <img src="<?php echo e(asset('storage/' . $news->image)); ?>" alt="<?php echo e($news->title); ?>">
                    </div>
                    <?php endif; ?>
                    <div class="blog-content">
                        <div class="blog-meta">
                            <a><i class="fa-light fa-calendar-days"></i> <?php echo e($news->created_at->format('d F, Y')); ?></a>
                        </div>
                        <h2 class="blog-title"><?php echo e($news->title); ?></h2>
                        <div class="blog-text">
                            <?php echo $news->content; ?>

                        </div>

                        <?php if(is_array(json_decode($news->gallery, true))): ?>
                        <div class="row mt-40" id="newsGallery">
                            <?php $__currentLoopData = json_decode($news->gallery, true); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $img): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>



                            <div class="col-md-3 mb-4">
                                <a href="<?php echo e(asset('storage/' . $img)); ?>" class="popup-image d-block rounded-3 overflow-hidden">
                                    <img class="w-100" src="<?php echo e(asset('storage/' . $img)); ?>" loading="lazy" alt="<?php echo e($news->title); ?>">
                                </a>
                            </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                        <?php endif; ?>



                        <div class="share-links clearfix">
                            <div class="row justify-content-between">
                                <div class="col-sm-auto">
                                    <span class="share-links-title">Etiketler:</span>
                                    <div class="tagcloud">
                                        
                                        <a href="#">Haber</a>
                                        <a href="#">Gelişme</a>
                                    </div>
                                </div>
                                <div class="col-sm-auto text-xl-end">
                                    <span class="share-links-title">Paylaş:</span>
                                    <ul class="social-links">
                                        <li><a href="#"><i class="fab fa-facebook-f"></i></a></li>
                                        <li><a href="#"><i class="fab fa-twitter"></i></a></li>
                                        <li><a href="#"><i class="fab fa-linkedin-in"></i></a></li>
                                        <li><a href="#"><i class="fab fa-instagram"></i></a></li>
                                    </ul>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="col-xxl-4 col-lg-5">
                <aside class="sidebar-area">
                    <div class="widget widget_search">
                        <form class="search-form">
                            <input type="text" placeholder="Kelime Ara">
                            <button type="submit"><i class="far fa-search"></i></button>
                        </form>
                    </div>
                    <div class="widget">
                        <h3 class="widget_title">Son Haberler</h3>
                        <div class="recent-post-wrap">
                          <?php $__currentLoopData = $news->take(5); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $recent): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                              <div class="recent-post">
                                  <div class="media-img">
                                      <a href="<?php echo e(route('news.detail', $recent->slug)); ?>">
                                          <img src="<?php echo e(asset('storage/' . $recent->image)); ?>" alt="<?php echo e($recent->title); ?>">
                                      </a>
                                  </div>
                                  <div class="media-body">
                                      <h4 class="post-title"><a class="text-inherit" href="<?php echo e(route('news.detail', $recent->slug)); ?>"><?php echo e($recent->title); ?></a></h4>
                                      <div class="recent-post-meta">
                                          <a href="#"><i class="fal fa-calendar-days"></i> <?php echo e($recent->created_at->format('d M, Y')); ?></a>
                                      </div>
                                  </div>
                              </div>
                          <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    </div>
                </aside>
            </div>
        </div>
    </div>
</section>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('lyt.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/tabidor/tabid/resources/views/pages/news-detail.blade.php ENDPATH**/ ?>