<?php
    $hasChildren = $menu->children->count() > 0;
    $isActive = request()->is(ltrim($menu->url, '/')) ? 'active' : '';
    $hasChildrenClass = $hasChildren ? 'menu-item-has-children' : '';
    $imageUrl = $menu->images ? asset('storage/' . $menu->images) : null;
?>

<li class="scroll <?php echo e($hasChildrenClass); ?> <?php echo e($isActive); ?>">
    <a href="<?php echo e(url($menu->url ?? ($menu->page ? url($menu->page->slug) : '#'))); ?>">
        <?php if($imageUrl): ?>
            <img src="<?php echo e($imageUrl); ?>" alt="<?php echo e($menu->label); ?>" style="max-height: 70px;">
        <?php else: ?>
            <?php echo e($menu->label); ?>

        <?php endif; ?>
    </a>

    <?php if($hasChildren): ?>
        <ul class="sub-menu">
            <?php $__currentLoopData = $menu->children; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $child): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <?php echo $__env->make('lyt.partials.menu-item', ['menu' => $child], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </ul>
    <?php endif; ?>
</li>
<?php /**PATH /home/kubeycr/figenkonak/resources/views/lyt/partials/menu-item.blade.php ENDPATH**/ ?>